<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->
  
  <!-- A GENERIC TRANSFORM TEMPLATE TO EMIT HTML -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="1.0">
   

 <xsl:output method="html" omit-xml-declaration="yes"/>

  
  <xsl:template match="Template">
    <html>
    <head><title>HTML Output example</title></head>
    <body>
      <xsl:apply-templates select="Cover" />
      <xsl:apply-templates select="Section" />
    </body>
  </html>
  </xsl:template>
  
<xsl:template match="Cover">
  <center>
  <h3>Authored by <xsl:value-of select="AuthorName"/></h3>
  <h1><xsl:value-of select="Title"/></h1>
  <h2>Version <xsl:value-of select="Version"/></h2>
  <h3>Document number <xsl:value-of select="DocumentNumber"/></h3>
  </center>
  <hr/>
</xsl:template>
   
<xsl:template match="Section">
  <div>
  <h1><xsl:value-of select="SectionTitle"/></h1>
  <xsl:apply-templates select="SectionContent" />
  </div>
  <hr/>
</xsl:template>
   

<xsl:template match="Paragraph">
  <p><xsl:apply-templates />
  </p>
</xsl:template>
   
<xsl:template match="List">
  <xsl:if test="@style='unordered'">
  <ul><xsl:apply-templates />
  </ul>
  </xsl:if>
</xsl:template>
   
<xsl:template match="Member">
  <li><xsl:apply-templates /></li>
</xsl:template>
   
   

</xsl:transform>

 