<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->
  
  <!-- A GENERIC TRANSFORM TEMPLATE TO EMIT HTML -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="1.0">
   

 <xsl:output method="text" omit-xml-declaration="yes"/>

  
<xsl:template match="Template">
:userdoc.
:title.Information Presentation Facility (IPF) Output
<xsl:apply-templates select="Cover" />
<xsl:apply-templates select="Section" >
  <xsl:with-param name="depth" select='1' />
</xsl:apply-templates>
:euserdoc.
</xsl:template>
  
<xsl:template match="Cover">
:h1.Cover Sheet
:lines align=center.:font facename='Tms Rmn' size=16x16.Authored by <xsl:value-of select="AuthorName"/>
<xsl:text>

</xsl:text>:font facename=Helv size=24x24.:color fc=yellow bc=blue.<xsl:value-of select="Title"/>

:font facename=Helv size=16x16.:color fc=default bc=default.Version <xsl:value-of select="Version"/>

Document number <xsl:value-of select="DocumentNumber"/>
:elines.</xsl:template>
   
<xsl:template match="Section">
  <xsl:param name='depth' />
:h<xsl:value-of select='$depth'/>.<xsl:value-of select="SectionTitle"/>
<xsl:apply-templates select="SectionContent" />
<xsl:apply-templates select="Section" >
  <xsl:with-param name="depth" select="$depth + 1" />
</xsl:apply-templates>
</xsl:template>
   

<xsl:template match="Paragraph">
:p.<xsl:apply-templates /></xsl:template>


<xsl:template match="List">
 <xsl:if test="@style='presentation'">
:ul.<xsl:apply-templates mode='presentation'/>
:eul.
</xsl:if>
<xsl:if test="@style='unordered'">
:ul.<xsl:apply-templates />
:eul.
</xsl:if>
<xsl:if test="@style='ordered'">
:ol.<xsl:apply-templates />
:eol.
</xsl:if>
</xsl:template>
   
   
<xsl:template match="Member" mode="presentation">
:li.:font facename='Helv' size='36x20'.<xsl:apply-templates /> :font size='0x0'.
</xsl:template>

<xsl:template match="Member">
:li.<xsl:apply-templates />
</xsl:template>

<xsl:template match="PageLink">
:p. <xsl:apply-templates />
</xsl:template>

</xsl:transform>

 