<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               version="1.0">
   

 <xsl:output method="html" omit-xml-declaration="yes"/>

  
  <xsl:template match="/">
    <html>
    <head><title>Technical Note</title></head>
    <body>
      <xsl:apply-templates select="//TechNote/Cover" />
    <center><h1>Table of Contents</h1></center>
      <xsl:apply-templates select="//TechNote/Section" mode="toc" />
    <hr/>
       <xsl:apply-templates select="//TechNote/Section" />
    </body>
  </html>
  </xsl:template>


  
   
  <xsl:template match="Cover">
    <center>
    <h1><xsl:value-of select="./Title" /></h1>
    <br/>
    <h2>Author:  <xsl:value-of select="./AuthorName" /></h2>
    <br/>
    <h3>Version: <xsl:value-of select="./Version" /></h3>
    <br/>
    <h3>Document number:  <xsl:value-of select="./DocumentNumber"  /></h3>
    <hr/>
  </center>
  </xsl:template>


  <!-- THE SECTION TEMPLATE
       is quite elaborate because sections are recursively
     nested, and numbered using the Dewey decimal system
  -->

  <!-- THE TOC VERSION -->

  
  <xsl:template match="Section" mode="toc">
       <xsl:param name="numberingPrefix"/>
     <xsl:variable name="depth" >
       <xsl:value-of select="count(./ancestor::node())" />
     </xsl:variable >
     <xsl:variable name="numberParam">
       <xsl:number />
     </xsl:variable>
     <xsl:variable name="dooeyParam" select="$numberingPrefix" />
     <xsl:variable name="anchorValue">
       <xsl:value-of select="$dooeyParam"/><xsl:number/>
     </xsl:variable>

     <!-- the TITLE element is a pain in the neck because we
         need to create different text styles for each depth
         into the section nesting.
    -->   
      <a name="toc_{$anchorValue}"></a><a href="#{$anchorValue}">
      <xsl:choose>
       <xsl:when test="$depth='1'">
       <strong><xsl:value-of select="$dooeyParam"/><xsl:number/>
       <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></strong><br/>
     </xsl:when>
       <xsl:when test="$depth='2'">
       <br/><br/><strong><xsl:value-of select="$dooeyParam"/><xsl:number/>
       <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></strong><br/>
     </xsl:when>
       <xsl:when test="$depth='3'">
       <br/><i><xsl:value-of select="$dooeyParam"/><xsl:number/>
       <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></i><br/>
     </xsl:when>
       <xsl:when test="$depth='4'">
       <small><xsl:value-of select="$dooeyParam"/>
       <xsl:number/><xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></small><br/>
     </xsl:when>
       <xsl:when test="$depth='5'">
       <small><xsl:value-of select="$dooeyParam"/>
       <xsl:number/><xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></small><br/>
     </xsl:when>
       <xsl:when test="$depth='6'">
       <small><xsl:value-of select="$dooeyParam"/>
       <xsl:number/><xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></small><br/>
     </xsl:when>
       <xsl:when test="$depth='7'">
       <small><xsl:value-of select="$dooeyParam"/>
       <xsl:number/><xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" /></small><br/>
     </xsl:when>
    </xsl:choose>
    </a>
    <xsl:apply-templates select="./Section" mode="toc">
        <xsl:with-param name="numberingPrefix" select="concat($dooeyParam,$numberParam,'.' )" />
     </xsl:apply-templates >

  </xsl:template>  

    
  <!-- END OF TOC VERSION -->
  
  <xsl:template match="Section">
       <xsl:param name="numberingPrefix"/>
     <xsl:variable name="depth" >
       <xsl:value-of select="count(./ancestor::node())" />
     </xsl:variable >
     <xsl:variable name="numberParam">
       <xsl:number />
     </xsl:variable>
     <xsl:variable name="dooeyParam" select="$numberingPrefix" />
     <xsl:variable name="anchorValue">
       <xsl:value-of select="$dooeyParam"/><xsl:number/>
     </xsl:variable>
    <div>
     <!-- the TITLE is less of a pain in the neck here because.
       we do not have to choose the <h#> level by brute force;
       we can use the <xsl:element> element's name attribute 
       to do the work
    -->   
      <a name="{$anchorValue}"></a>
      <a href="#toc_{$anchorValue}">
        <xsl:element name="{concat('h',($depth - 1))}">
          <xsl:value-of select="$dooeyParam"/><xsl:number/>
          <xsl:text>    </xsl:text><xsl:value-of select="./SectionTitle" />
        </xsl:element>
      </a>
     
        <xsl:apply-templates select="./SectionContent" />
        <xsl:apply-templates select="./Section">
        <xsl:with-param name="numberingPrefix" select="concat($dooeyParam,$numberParam,'.' )" />
     </xsl:apply-templates >

  </div>
  </xsl:template>  




  <xsl:template match="UseCase">
    <table border="1">
    <tr><td>Use Case Name</td><td colspan="2"><xsl:value-of select="./UseCaseTitle" /></td></tr>
    <tr><td>Requirement</td><td colspan="2"><xsl:value-of select="./UCRequirement" /></td></tr>
    <tr><td>Goal</td><td colspan="2"><xsl:value-of select="./UCGoal" /></td></tr>
    <tr><td>Preconditions</td><td colspan="2"><xsl:apply-templates select="./UCPreconditions" /></td></tr>
    <tr><td>Actors</td><td colspan="2"><xsl:apply-templates select="./UCActors" /></td></tr>
    <tr><td>Description</td><td>Step</td><td>Action</td></tr>
    <xsl:apply-templates select="./UCDescription/Paragraph" />
    <tr><td>Result</td><td colspan="2"><xsl:apply-templates select="./UCResult" /></td></tr>
   </table>    
  </xsl:template>

  
  <xsl:template match="UCDescription/Paragraph">
    <tr><td> </td><td><xsl:number /></td><td><xsl:apply-templates /></td></tr>
  </xsl:template>


  <xsl:template match="ImageLink">
    <br/>
  <center>
    <strong><xsl:value-of select='.' /></strong>
    <br/>
    <img alt='{.}' border='0' src='{@xlink:href}'/>
  </center>
  </xsl:template>

  <xsl:template match="PageLink">
    <a href='{@xlink:href}'><xsl:value-of select='.' /></a>
  </xsl:template>

  <xsl:template match="Paragraph">
    <p><xsl:apply-templates  /></p>
  </xsl:template>

  <xsl:template match="T">
    <xsl:value-of select="." />
   </xsl:template>
 
  <xsl:template match="GlossaryEntry">
    <xsl:value-of select="./FullName"/> (<strong><xsl:value-of select="./Abbreviation"/></strong>) 
  </xsl:template>

  <xsl:template match="List">
    <xsl:if test="@style='ordered'">
    <ol>
    <xsl:apply-templates />
  </ol>
  </xsl:if>
    <xsl:if test="@style!='ordered'">
    <ul>
    <xsl:apply-templates />
  </ul>
  </xsl:if>
  </xsl:template>
  
  <xsl:template match="Member">
    <li><xsl:apply-templates /></li>
  </xsl:template>


  <xsl:template match="Emphasis[@intensity='high']">
    <strong><xsl:value-of select="."/></strong>
  </xsl:template>

  <xsl:template match="Emphasis">
    <i><xsl:value-of select="."/></i>
  </xsl:template>

  <xsl:template match="Table">
    <table border="1">
    <xsl:apply-templates />
  </table>
  </xsl:template>
    
  <xsl:template match="TableRow">
    <tr>
    <xsl:apply-templates />
  </tr>
  </xsl:template>


  <xsl:template match="TableCell">
    <td>
    <xsl:apply-templates />
  </td>
  </xsl:template>
</xsl:transform>
